/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
           /***********************  EXAMPLE FOR EDGEHERO.COM *********************************
            //                        Drag and Drop Using jqueryUI
            //                             by Marie Goodwyn
            //  						Please direct your comment  or questions at
            // http://www.edgehero.com/BlogRetrieve.aspx?BlogID=9972&PostID=320539&Preview=true
            //
            /***********************************************************************************/
         
            // make an array of the draggable symbol names
            var shapes = ['txtmouse','txtkeyboard','txtspeakers','txtmonitor','txtsystem','txtprinter'];
            // make an array of the droppable element names
            var targets = ['dmouse','dkeyboard','dspeakers','dmonitor','dsystem','dprinter'];
            // have only the first element be draggable
         
         var Pos = [
         {'x':1,'y':405},
         {'x':81,'y':441},
         {'x':194,'y':405},
         {'x':294,'y':441},
         {'x':403,'y':405},
         {'x':474,'y':441},
         
            ];
         
         k=0;
         
         
          for (i=0;i<shapes.length;i++){	
            	sym.$(shapes[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(shapes[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:0,
            	});
         
         
         
            	sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
            }
         
         
         function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               //ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'center' } );
                ui.draggable.draggable( 'option', 'revert', false );
               // playsound();
               //alert(ui.draggable.attr("id"));
         
               var p = ui.draggable.attr("id");
         
               k++;
         
         		playsound(p);
         		checkAnimation();
         
            }
         
         
         function checkAnimation(){
         	if (k==6){
         
          		 sym.$("welldone")[0].play();
         //sym.$("line1").delay(4000).fadeIn(1000);
         
         		sym.$("gfeedback").fadeIn(1000);
         	}
         
         	}
         
         
         function playsound(r){
         
         if(r=='Stage_txtmouse'){
         
         			sym.$("mouseaudio")[0].currentTime = 0;
         		if (sym.$("mouseaudio")[0].paused) 
         				{
         				sym.$("mouseaudio")[0].play();
         				}
         
         			}
           if(r=='Stage_txtkeyboard'){
         
         			sym.$("keyboardaudio")[0].currentTime = 0;
         			if (sym.$("keyboardaudio")[0].paused) 
         			{
         			sym.$("keyboardaudio")[0].play();
         			}
         		}
         
           if(r=='Stage_txtspeakers'){
         
         			sym.$("speakersaudio")[0].currentTime = 0;
         		if (sym.$("speakersaudio")[0].paused) 
         				{
         				sym.$("speakersaudio")[0].play();
         				}
         
         			}
         
         	if(r=='Stage_txtmonitor'){
         
         				sym.$("monitoraudio")[0].currentTime = 0;
         			if (sym.$("monitoraudio")[0].paused) 
         					{
         					sym.$("monitoraudio")[0].play();
         					}
         
         				}
         
         	if(r=='Stage_txtsystem'){
         
         			sym.$("systemaudio")[0].currentTime = 0;
         		if (sym.$("systemaudio")[0].paused) 
         				{
         				sym.$("systemaudio")[0].play();
         				}
         
         			}
         
         if(r=='Stage_txtprinter'){
         
         			sym.$("printeraudio")[0].currentTime = 0;
         		if (sym.$("printeraudio")[0].paused) 
         				{
         				sym.$("printeraudio")[0].play();
         				}
         
         			}
         }
         
         sym.$('btnreload').click(function(){
            	window.location.reload()
            });
         
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${play3}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("group").hide(1000);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${audio}", "click", function(sym, e) {
         // insert code for mouse click here
         // Play an audio track 
         sym.$("instruction")[0].play();
         

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${btnreload}", "click", function(sym, e) {
         // insert code for mouse click here
         // Navigate to a new URL in the current window
         // (replace "_self" with appropriate target attribute)
         window.open("index.html", "_self");
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'txtkeyboard'
   (function(symbolName) {   
   
   })("txtkeyboard");
   //Edge symbol end:'txtkeyboard'

   //=========================================================
   
   //Edge symbol: 'txtmouse'
   (function(symbolName) {   
   
   })("txtmouse");
   //Edge symbol end:'txtmouse'

   //=========================================================
   
   //Edge symbol: 'txtspeakers'
   (function(symbolName) {   
   
   })("txtspeakers");
   //Edge symbol end:'txtspeakers'

   //=========================================================
   
   //Edge symbol: 'txtmonitor'
   (function(symbolName) {   
   
   })("txtmonitor");
   //Edge symbol end:'txtmonitor'

   //=========================================================
   
   //Edge symbol: 'txtsystem'
   (function(symbolName) {   
   
   })("txtsystem");
   //Edge symbol end:'txtsystem'

   //=========================================================
   
   //Edge symbol: 'txtprinter'
   (function(symbolName) {   
   
   })("txtprinter");
   //Edge symbol end:'txtprinter'

   //=========================================================
   
   //Edge symbol: 'btnreload'
   (function(symbolName) {   
   
   })("btnreload");
   //Edge symbol end:'btnreload'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-2048057");